/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache;

import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Expiry;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.LocalCacheFactory;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Pacer;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Scheduler;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Ticker;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.TimerWheel;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.WIMS;
import org.checkerframework.checker.nullness.qual.Nullable;

class WIMSA<K, V>
extends WIMS<K, V> {
    static final LocalCacheFactory FACTORY = WIMSA::new;
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    WIMSA(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

